Object subclass: #Client
	instanceVariableNames: 'email interets serveurSMTP '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Applications-Routage de mails'!

!Client methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:39'!
email
	^email! !

!Client methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:39'!
email: unEmail
	email := unEmail! !

!Client methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:40'!
interets
	^interets! !

!Client methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:40'!
interets: uneCollectionDInterets
	interets := uneCollectionDInterets! !

!Client methodsFor: 'accessing' stamp: 'XB 8/3/2001 15:02'!
nouvelInteret: unInteret
	self interets add: unInteret! !

!Client methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:06'!
serveurSMTP
	serveurSMTP isNil ifTrue: [serveurSMTP := FillInTheBlank request: 'Serveur SMTP' initialAnswer: 'hendrix.limsi.fr'].
	^serveurSMTP ! !


!Client methodsFor: 'initialize' stamp: 'XB 8/3/2001 15:41'!
initialize
	email := String new.
	interets := OrderedCollection new! !


!Client methodsFor: 'printing' stamp: 'XB 8/3/2001 15:44'!
printOn: aStream
	aStream nextPutAll: self email! !


!Client methodsFor: 'notifications' stamp: 'XB 8/6/2001 11:08'!
mailRecu: unMail pourLInteret: unInteret
	Transcript cr; show: self printString; space; show: ' a t notifi du mail '; show: unMail printString; show: ' pour l''intrt '; show: unInteret printString.
	
	SMTPSocket deliverMailFrom: 'Routeur de mail Squeak' to: (Array with: email) text:
		('From: ',  'Routeur de mail Squeak', ' To: ',  email, ' Subject: notification pour l''interet ', unInteret printString, '\\\' withCRs, unMail contenu) usingServer: self serveurSMTP.
	Smalltalk garbageCollect	

	! !


!Client methodsFor: 'interets' stamp: 'XB 8/4/2001 15:00'!
interetsPour: unMail
	^self interets select:  [:unInteret| unInteret estInteressePar: unMail]! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Client class
	instanceVariableNames: ''!

!Client class methodsFor: 'instance creation' stamp: 'XB 8/3/2001 14:46'!
new
	^super new initialize! !


!Client class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:01'!
client1
	| client |
	client := self new.
	client email: 'xavier@limsi.fr'. 
	client nouvelInteret: Interet interet1.
	client nouvelInteret: Interet interet2.
	^ client
! !

!Client class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:02'!
client2
	| client |
	client := self new.
	client email: 'xavier@limsi.fr'. 
	client nouvelInteret: Interet interet3.
	client nouvelInteret: Interet interet4.
	^ client
! !

!Client class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:06'!
clients
	^OrderedCollection with: self client1 with: self client2! !


Object subclass: #Interet
	instanceVariableNames: 'motsRecherches '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Applications-Routage de mails'!

!Interet methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:42'!
motsRecherches
	^motsRecherches! !


!Interet methodsFor: 'initialize' stamp: 'XB 8/3/2001 15:41'!
initialize

	motsRecherches := OrderedCollection new! !

!Interet methodsFor: 'initialize' stamp: 'XB 8/6/2001 16:36'!
motsRecherches: listeDeMots
	motsRecherches := (listeDeMots collect: [:each| each withBlanksTrimmed])! !


!Interet methodsFor: 'printing' stamp: 'XB 8/3/2001 15:44'!
printOn: aStream
	aStream nextPutAll: self motsRecherches printString! !


!Interet methodsFor: 'evaluation' stamp: 'XB 8/3/2001 15:30'!
estInteressePar: unMessage
	| mots |
	mots := unMessage contenu mots.
	self motsRecherches do: [:unMot|
		(mots includes: unMot) ifFalse: [^false]].
	^true
	! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Interet class
	instanceVariableNames: ''!

!Interet class methodsFor: 'instance creation' stamp: 'XB 8/3/2001 14:47'!
new
	^super new initialize! !


!Interet class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:42'!
interet1
	| int |
	int := self new.
	int motsRecherches: #('UNIX' 'XML').
	^int! !

!Interet class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:42'!
interet2
	| int |
	int := self new.
	int motsRecherches: #('SQUEAK' ).
	^int! !

!Interet class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:42'!
interet3
	| int |
	int := self new.
	int motsRecherches: #('SMTP' ).
	^int! !

!Interet class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:42'!
interet4
	| int |
	int := self new.
	int motsRecherches: #('portail' ).
	^int! !


Object subclass: #LecteurDeMail
	instanceVariableNames: 'serveurPOP nomUtilisateur motDePasse process nbSecondes actif routeur '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Applications-Routage de mails'!

!LecteurDeMail methodsFor: 'gestion des messages' stamp: 'XB 8/6/2001 16:50'!
notifierRouteurDesMessages: listeDeMessages
	(listeDeMessages select: [:unMessage| unMessage  subject = 'subscribe']) do: [:unMessage| routeur nouvelInteret: (unMessage body content findTokens: Character space) pourLeClient: unMessage  from].
	(listeDeMessages reject: [:unMessage| unMessage  subject = 'subscribe']) do: [:unMessage| routeur routeMessage: (Mail fromPOPMailString: unMessage text)].! !


!LecteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/5/2001 15:00'!
arreter
	actif := false. 
! !

!LecteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/6/2001 15:48'!
commenceLectureToutesLes: nombreDeSecondes
	| popSocket  |
	nbSecondes  :=  nombreDeSecondes.
	popSocket := POPSocket new.
	popSocket serverName: (self serveurPOP).
	popSocket userName: (self nomUtilisateur).
	popSocket password: (self motDePasse).
	actif := true.
	process := [|messages|
		messages := OrderedCollection new. 
		popSocket connectToPOP.
		[[actif] whileTrue: [
			popSocket messagesDo: [ :messageText | messages add: messageText].
			self notifierRouteurDesMessages: (messages collect: [:unMessage| MailMessage from: unMessage]) .
			(Delay forSeconds: nbSecondes) wait.
			messages := OrderedCollection new. ]] ensure: [popSocket disconnectFromPOP. messages := OrderedCollection new.]] newProcess.
	process resume.! !

!LecteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/5/2001 15:00'!
stop
	self arreter
! !


!LecteurDeMail methodsFor: 'initialize' stamp: 'XB 8/5/2001 15:06'!
initialize
	nbSecondes := 20.
	actif := false. ! !


!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:04'!
motDePasse
	motDePasse isNil ifTrue: [motDePasse := FillInTheBlank requestPassword: 'POP password' ].
	^motDePasse! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:04'!
nomUtilisateur 
	nomUtilisateur isNil ifTrue: [nomUtilisateur := FillInTheBlank request: 'POP User name' initialAnswer: 'xavier'].
	^nomUtilisateur ! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/5/2001 14:19'!
routeur
	^routeur ! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/5/2001 14:19'!
routeur: unRouteur
	routeur := unRouteur! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:04'!
serveurPOP 
	serveurPOP isNil ifTrue: [serveurPOP := FillInTheBlank request: 'POP Server' initialAnswer: 'hendrix.limsi.fr'].
	^serveurPOP ! !


!LecteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/5/2001 15:00'!
arreter
	actif := false. 
! !

!LecteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/6/2001 15:48'!
commenceLectureToutesLes: nombreDeSecondes
	| popSocket  |
	nbSecondes  :=  nombreDeSecondes.
	popSocket := POPSocket new.
	popSocket serverName: (self serveurPOP).
	popSocket userName: (self nomUtilisateur).
	popSocket password: (self motDePasse).
	actif := true.
	process := [|messages|
		messages := OrderedCollection new. 
		popSocket connectToPOP.
		[[actif] whileTrue: [
			popSocket messagesDo: [ :messageText | messages add: messageText].
			self notifierRouteurDesMessages: (messages collect: [:unMessage| MailMessage from: unMessage]) .
			(Delay forSeconds: nbSecondes) wait.
			messages := OrderedCollection new. ]] ensure: [popSocket disconnectFromPOP. messages := OrderedCollection new.]] newProcess.
	process resume.! !

!LecteurDeMail methodsFor: 'initialize' stamp: 'XB 8/5/2001 15:06'!
initialize
	nbSecondes := 20.
	actif := false. ! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:04'!
motDePasse
	motDePasse isNil ifTrue: [motDePasse := FillInTheBlank requestPassword: 'POP password' ].
	^motDePasse! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:04'!
nomUtilisateur 
	nomUtilisateur isNil ifTrue: [nomUtilisateur := FillInTheBlank request: 'POP User name' initialAnswer: 'xavier'].
	^nomUtilisateur ! !

!LecteurDeMail methodsFor: 'gestion des messages' stamp: 'XB 8/6/2001 16:50'!
notifierRouteurDesMessages: listeDeMessages
	(listeDeMessages select: [:unMessage| unMessage  subject = 'subscribe']) do: [:unMessage| routeur nouvelInteret: (unMessage body content findTokens: Character space) pourLeClient: unMessage  from].
	(listeDeMessages reject: [:unMessage| unMessage  subject = 'subscribe']) do: [:unMessage| routeur routeMessage: (Mail fromPOPMailString: unMessage text)].! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/5/2001 14:19'!
routeur
	^routeur ! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/5/2001 14:19'!
routeur: unRouteur
	routeur := unRouteur! !

!LecteurDeMail methodsFor: 'accessing' stamp: 'XB 8/6/2001 11:04'!
serveurPOP 
	serveurPOP isNil ifTrue: [serveurPOP := FillInTheBlank request: 'POP Server' initialAnswer: 'hendrix.limsi.fr'].
	^serveurPOP ! !

!LecteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/5/2001 15:00'!
stop
	self arreter
! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

LecteurDeMail class
	instanceVariableNames: ''!

!LecteurDeMail class methodsFor: 'instance creation' stamp: 'XB 8/5/2001 14:05'!
new
	^super new initialize! !


Object subclass: #Mail
	instanceVariableNames: 'expediteur contenu '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Applications-Routage de mails'!

!Mail methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:44'!
contenu
	^contenu! !

!Mail methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:45'!
contenu: unTexte
	contenu := unTexte! !

!Mail methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:44'!
expediteur
	^expediteur! !

!Mail methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:44'!
expediteur: unExpediteur
	expediteur := unExpediteur! !


!Mail methodsFor: 'initialize' stamp: 'XB 8/3/2001 15:42'!
initialize

	expediteur := String new.
	contenu := String new. ! !


!Mail methodsFor: 'printing' stamp: 'XB 8/3/2001 15:45'!
printOn: aStream
	aStream nextPutAll: self contenu! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Mail class
	instanceVariableNames: ''!

!Mail class methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:48'!
new
	^super new initialize! !


!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:15'!
message1
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Nouveaux outils XML pour UNIX BSD'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:16'!
message2
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Nouveaux outils  pour SMTP sous Windows'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:16'!
message3
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Nouveaux outils  pour le portail Toto sous Windows'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:17'!
message4
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Nouveaux outils  pour SQUEAK sous Windows'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:17'!
message5
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Sans intrt'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/4/2001 15:04'!
message6
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'UNIX et c''est tout'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:17'!
message7
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Sans intrt'.
	^mess! !

!Mail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:17'!
message8
	| mess |
	mess := self new.
	mess expediteur: 'AFP@AFP.fr'.
	mess contenu: 'Sans intrt'.
	^mess! !


!Mail class methodsFor: 'instance creation' stamp: 'XB 8/5/2001 15:36'!
fromPOPMailString: aPOPMailString
	| popMail mail |
	popMail := MailMessage from: aPOPMailString.
	mail := self new.
	mail expediteur: (popMail fields at: 'from') mainValue;
		 contenu: (popMail body content).
	^mail! !


Object subclass: #RouteurDeMail
	instanceVariableNames: 'clients lecteurDeMail '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Applications-Routage de mails'!

!RouteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/5/2001 15:00'!
arreter
	lecteurDeMail arreter! !

!RouteurDeMail methodsFor: 'dmarrage/arrt' stamp: 'XB 8/6/2001 15:41'!
demarrer
	lecteurDeMail commenceLectureToutesLes: 20.! !


!RouteurDeMail methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:45'!
clients
	^clients! !

!RouteurDeMail methodsFor: 'accessing' stamp: 'XB 8/3/2001 14:46'!
clients: uneCollectionDeClients
	clients := uneCollectionDeClients! !


!RouteurDeMail methodsFor: 'notifications' stamp: 'XB 8/6/2001 15:41'!
ajouterInteret: uneListeDeMots auClient: unEMail 
	(self clientDEMail: unEMail) nouvelInteret: (Interet new motsRecherches: uneListeDeMots)
! !

!RouteurDeMail methodsFor: 'notifications' stamp: 'XB 8/6/2001 15:39'!
clientDEMail: unEMail
 	^self clients detect: [:unClient| unClient email = unEMail] ifNone: [nil].! !

!RouteurDeMail methodsFor: 'notifications' stamp: 'XB 8/6/2001 15:56'!
creerClientSiNecessaire: unEMail
	| client |
	client := self clientDEMail: unEMail. 
	client isNil ifTrue: [client := Client new email: unEMail].
	self clients add: client. 
	^ client
! !

!RouteurDeMail methodsFor: 'notifications' stamp: 'XB 8/5/2001 15:01'!
notifierClient: unClient duMail: unMail pourLInteret: unInteret
 	unClient mailRecu: unMail pourLInteret: unInteret! !

!RouteurDeMail methodsFor: 'notifications' stamp: 'XB 8/6/2001 17:00'!
nouvelInteret: uneListeDeMots pourLeClient: unEMail
	self creerClientSiNecessaire: unEMail.
	self ajouterInteret: uneListeDeMots auClient: unEMail. 
! !


!RouteurDeMail methodsFor: 'routage' stamp: 'XB 8/5/2001 15:41'!
routeMessage: unMail
	| interets |

	self clients do: [:unClient|	
		interets := unClient interetsPour: unMail. 
		interets notEmpty ifTrue: [
			 interets do: [:unInteret| unClient mailRecu:  unMail pourLInteret: unInteret]]]! !


!RouteurDeMail methodsFor: 'initialize' stamp: 'XB 8/5/2001 14:42'!
initialize
	self clients: OrderedCollection new.
	lecteurDeMail := LecteurDeMail new routeur: self. ! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

RouteurDeMail class
	instanceVariableNames: ''!

!RouteurDeMail class methodsFor: 'exemples' stamp: 'XB 8/3/2001 15:39'!
exemple
	| routeur |
	"RouteurDeMail exemple"
	routeur := self new.
	routeur clients: Client clients. 
	routeur routeMessage: Mail message1.
	routeur routeMessage: Mail message2.
	routeur routeMessage: Mail message3.
	routeur routeMessage: Mail message4.
	routeur routeMessage: Mail message5.
	routeur routeMessage: Mail message6.
	routeur routeMessage: Mail message7.
	routeur routeMessage: Mail message8.! !

!RouteurDeMail class methodsFor: 'exemples' stamp: 'XB 8/5/2001 16:19'!
exemplePOP
	| routeur |
	"RouteurDeMail exemplePOP"

	SMTPSocket deliverMailFrom: 'Squeak' to: #('xavier@limsi.fr') text:
		'From: Squeak
		To: xavier@limsi.fr
		Subject: this is a test	

		Hello from SQUEAK !!'usingServer: 'hendrix.limsi.fr'.
	Smalltalk garbageCollect.
	

	SMTPSocket deliverMailFrom: 'Squeak' to: #('xavier@limsi.fr') text:
		'From: Squeak
		To: xavier@limsi.fr
		Subject: this is a test	

		Nouvelles de XML pour UNIX  !!'usingServer: 'hendrix.limsi.fr'.
	Smalltalk garbageCollect.

	SMTPSocket deliverMailFrom: 'Squeak' to: #('xavier@limsi.fr') text:
		'From: Squeak
		To: xavier@limsi.fr
		Subject: this is a test	

	   UNIX  : ce mail n''est pas intressant !!'usingServer: 'hendrix.limsi.fr'.
	Smalltalk garbageCollect. 

	routeur := self new.
	routeur clients: Client clients. 
	routeur demarrer. 
	^routeur! !

!RouteurDeMail class methodsFor: 'exemples' stamp: 'XB 8/6/2001 16:33'!
exempleSouscription
	| routeur |
	"RouteurDeMail exempleSouscription"

	SMTPSocket deliverMailFrom: 'xavier@limsi.fr' to: #('xavier@limsi.fr') text:
		'From: xavier@limsi.fr
To: xavier@limsi.fr
Subject: subscribe	

SQUEAK' usingServer: 'hendrix.limsi.fr'.
	Smalltalk garbageCollect.
	
	SMTPSocket deliverMailFrom: 'Squeak' to: #('xavier@limsi.fr') text:
		'From: Squeak
To: xavier@limsi.fr
Subject: this is a test	

Nouvelles de SQUEAK pour UNIX  !!'usingServer: 'hendrix.limsi.fr'.
	Smalltalk garbageCollect.

	routeur := self new.
	routeur demarrer. 
	^routeur! !


!RouteurDeMail class methodsFor: 'instance creation' stamp: 'XB 8/3/2001 14:53'!
new
	^super new initialize! !
